/*
 * Decompiled with CFR 0.152.
 */
package com.howon.lifepass;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.howon.lifepass.R;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AlertActivity
extends AppCompatActivity {
    private OkHttpClient httpClient = new OkHttpClient();
    private List<DisasterMessage> messages = new ArrayList<DisasterMessage>();
    private LinearLayout messageList;
    private String selectedProvince = "";
    private String selectedCityCounty = "";
    private Map<String, List<String>> cityCountyMap;
    private int currentPage = 1;
    private boolean isLoading = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_alert);
        this.messageList = (LinearLayout)this.findViewById(R.id.messageContainer);
        this.initCityCountyMap();
        Spinner provinceSpinner = (Spinner)this.findViewById(R.id.regionSpinner);
        final Spinner cityCountySpinner = (Spinner)this.findViewById(R.id.cityCountySpinner);
        ArrayAdapter provinceAdapter = ArrayAdapter.createFromResource((Context)this, (int)R.array.provinces, (int)17367048);
        provinceAdapter.setDropDownViewResource(0x1090009);
        provinceSpinner.setAdapter((SpinnerAdapter)provinceAdapter);
        provinceSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                AlertActivity.this.selectedProvince = parent.getItemAtPosition(position).toString();
                List cityCountyList = (List)AlertActivity.this.cityCountyMap.get(AlertActivity.this.selectedProvince);
                if (cityCountyList != null) {
                    ArrayAdapter cityCountyAdapter = new ArrayAdapter((Context)AlertActivity.this, 17367048, cityCountyList);
                    cityCountyAdapter.setDropDownViewResource(0x1090009);
                    cityCountySpinner.setAdapter((SpinnerAdapter)cityCountyAdapter);
                }
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        cityCountySpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                AlertActivity.this.selectedCityCounty = parent.getItemAtPosition(position).toString();
                AlertActivity.this.currentPage = 1;
                AlertActivity.this.messages.clear();
                AlertActivity.this.fetchTotalPages();
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        EditText searchField = (EditText)this.findViewById(R.id.searchInput);
        searchField.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                List filtered = AlertActivity.this.filterMessages(s.toString());
                AlertActivity.this.updateMessageList(filtered);
            }

            public void afterTextChanged(Editable s) {
            }
        });
        ScrollView scrollView = (ScrollView)this.findViewById(R.id.scrollView);
        scrollView.getViewTreeObserver().addOnScrollChangedListener(() -> {
            View view = scrollView.getChildAt(scrollView.getChildCount() - 1);
            int diff = view.getBottom() - (scrollView.getHeight() + scrollView.getScrollY());
            if (diff == 0 && !this.isLoading) {
                ++this.currentPage;
                this.fetchMessages(this.currentPage);
            }
        });
    }

    private void initCityCountyMap() {
        this.cityCountyMap = new HashMap<String, List<String>>();
        this.cityCountyMap.put("\uc11c\uc6b8\ud2b9\ubcc4\uc2dc", Arrays.asList("\uac15\ub0a8\uad6c", "\uac15\ub3d9\uad6c", "\uac15\ubd81\uad6c", "\uac15\uc11c\uad6c", "\uad00\uc545\uad6c", "\uad11\uc9c4\uad6c", "\uad6c\ub85c\uad6c", "\uae08\ucc9c\uad6c", "\ub178\uc6d0\uad6c", "\ub3c4\ubd09\uad6c", "\ub3d9\ub300\ubb38\uad6c", "\ub3d9\uc791\uad6c", "\ub9c8\ud3ec\uad6c", "\uc11c\ub300\ubb38\uad6c", "\uc11c\ucd08\uad6c", "\uc131\ub3d9\uad6c", "\uc131\ubd81\uad6c", "\uc1a1\ud30c\uad6c", "\uc591\ucc9c\uad6c", "\uc601\ub4f1\ud3ec\uad6c", "\uc6a9\uc0b0\uad6c", "\uc740\ud3c9\uad6c", "\uc885\ub85c\uad6c", "\uc911\uad6c", "\uc911\ub791\uad6c"));
        this.cityCountyMap.put("\ubd80\uc0b0\uad11\uc5ed\uc2dc", Arrays.asList("\uac15\uc11c\uad6c", "\uae08\uc815\uad6c", "\uae30\uc7a5\uad70", "\ub0a8\uad6c", "\ub3d9\uad6c", "\ub3d9\ub798\uad6c", "\ubd80\uc0b0\uc9c4\uad6c", "\ubd81\uad6c", "\uc0ac\uc0c1\uad6c", "\uc0ac\ud558\uad6c", "\uc11c\uad6c", "\uc218\uc601\uad6c", "\uc5f0\uc81c\uad6c", "\uc601\ub3c4\uad6c", "\uc911\uad6c", "\ud574\uc6b4\ub300\uad6c"));
        this.cityCountyMap.put("\ub300\uad6c\uad11\uc5ed\uc2dc", Arrays.asList("\ub0a8\uad6c", "\ub2ec\uc11c\uad6c", "\ub2ec\uc131\uad70", "\ub3d9\uad6c", "\ubd81\uad6c", "\uc11c\uad6c", "\uc218\uc131\uad6c", "\uc911\uad6c"));
        this.cityCountyMap.put("\uc778\ucc9c\uad11\uc5ed\uc2dc", Arrays.asList("\uac15\ud654\uad70", "\uacc4\uc591\uad6c", "\ubbf8\ucd94\ud640\uad6c", "\ub0a8\ub3d9\uad6c", "\ub3d9\uad6c", "\ubd80\ud3c9\uad6c", "\uc11c\uad6c", "\uc5f0\uc218\uad6c", "\uc639\uc9c4\uad70", "\uc911\uad6c"));
        this.cityCountyMap.put("\uad11\uc8fc\uad11\uc5ed\uc2dc", Arrays.asList("\uad11\uc0b0\uad6c", "\ub0a8\uad6c", "\ub3d9\uad6c", "\ubd81\uad6c", "\uc11c\uad6c"));
        this.cityCountyMap.put("\ub300\uc804\uad11\uc5ed\uc2dc", Arrays.asList("\ub300\ub355\uad6c", "\ub3d9\uad6c", "\uc11c\uad6c", "\uc720\uc131\uad6c", "\uc911\uad6c"));
        this.cityCountyMap.put("\uc6b8\uc0b0\uad11\uc5ed\uc2dc", Arrays.asList("\ub0a8\uad6c", "\ub3d9\uad6c", "\ubd81\uad6c", "\uc6b8\uc8fc\uad70", "\uc911\uad6c"));
        this.cityCountyMap.put("\uc138\uc885\ud2b9\ubcc4\uc790\uce58\uc2dc", Arrays.asList("\uc138\uc885\ud2b9\ubcc4\uc790\uce58\uc2dc"));
        this.cityCountyMap.put("\uacbd\uae30\ub3c4", Arrays.asList("\uac00\ud3c9\uad70", "\uace0\uc591\uc2dc", "\uacfc\ucc9c\uc2dc", "\uad11\uba85\uc2dc", "\uad11\uc8fc\uc2dc", "\uad6c\ub9ac\uc2dc", "\uad70\ud3ec\uc2dc", "\uae40\ud3ec\uc2dc", "\ub0a8\uc591\uc8fc\uc2dc", "\ub3d9\ub450\ucc9c\uc2dc", "\ubd80\ucc9c\uc2dc", "\uc131\ub0a8\uc2dc", "\uc218\uc6d0\uc2dc", "\uc2dc\ud765\uc2dc", "\uc548\uc0b0\uc2dc", "\uc548\uc131\uc2dc", "\uc548\uc591\uc2dc", "\uc591\uc8fc\uc2dc", "\uc591\ud3c9\uad70", "\uc5ec\uc8fc\uc2dc", "\uc5f0\ucc9c\uad70", "\uc624\uc0b0\uc2dc", "\uc6a9\uc778\uc2dc", "\uc758\uc655\uc2dc", "\uc758\uc815\ubd80\uc2dc", "\uc774\ucc9c\uc2dc", "\ud30c\uc8fc\uc2dc", "\ud3c9\ud0dd\uc2dc", "\ud3ec\ucc9c\uc2dc", "\ud558\ub0a8\uc2dc", "\ud654\uc131\uc2dc"));
        this.cityCountyMap.put("\uac15\uc6d0\ud2b9\ubcc4\uc790\uce58\ub3c4", Arrays.asList("\ucd98\ucc9c\uc2dc", "\uc6d0\uc8fc\uc2dc", "\uac15\ub989\uc2dc", "\ub3d9\ud574\uc2dc", "\ud0dc\ubc31\uc2dc", "\uc18d\ucd08\uc2dc", "\uc0bc\ucc99\uc2dc", "\ud64d\ucc9c\uad70", "\ud6a1\uc131\uad70", "\uc601\uc6d4\uad70", "\ud3c9\ucc3d\uad70", "\uc815\uc120\uad70", "\ucca0\uc6d0\uad70", "\ud654\ucc9c\uad70", "\uc591\uad6c\uad70", "\uc778\uc81c\uad70", "\uace0\uc131\uad70", "\uc591\uc591\uad70"));
        this.cityCountyMap.put("\ucda9\uccad\ubd81\ub3c4", Arrays.asList("\uccad\uc8fc\uc2dc", "\ucda9\uc8fc\uc2dc", "\uc81c\ucc9c\uc2dc", "\ubcf4\uc740\uad70", "\uc625\ucc9c\uad70", "\uc601\ub3d9\uad70", "\uc99d\ud3c9\uad70", "\uc9c4\ucc9c\uad70", "\uad34\uc0b0\uad70", "\uc74c\uc131\uad70", "\ub2e8\uc591\uad70"));
        this.cityCountyMap.put("\ucda9\uccad\ub0a8\ub3c4", Arrays.asList("\ucc9c\uc548\uc2dc", "\uacf5\uc8fc\uc2dc", "\ubcf4\ub839\uc2dc", "\uc544\uc0b0\uc2dc", "\uc11c\uc0b0\uc2dc", "\ub17c\uc0b0\uc2dc", "\uacc4\ub8e1\uc2dc", "\ub2f9\uc9c4\uc2dc", "\uae08\uc0b0\uad70", "\ubd80\uc5ec\uad70", "\uc11c\ucc9c\uad70", "\uccad\uc591\uad70", "\ud64d\uc131\uad70", "\uc608\uc0b0\uad70", "\ud0dc\uc548\uad70"));
        this.cityCountyMap.put("\uc804\ub77c\ubd81\ub3c4", Arrays.asList("\uc804\uc8fc\uc2dc", "\uad70\uc0b0\uc2dc", "\uc775\uc0b0\uc2dc", "\uc815\uc74d\uc2dc", "\ub0a8\uc6d0\uc2dc", "\uae40\uc81c\uc2dc", "\uc644\uc8fc\uad70", "\uc9c4\uc548\uad70", "\ubb34\uc8fc\uad70", "\uc7a5\uc218\uad70", "\uc784\uc2e4\uad70", "\uc21c\ucc3d\uad70", "\uace0\ucc3d\uad70", "\ubd80\uc548\uad70"));
        this.cityCountyMap.put("\uc804\ub77c\ub0a8\ub3c4", Arrays.asList("\ubaa9\ud3ec\uc2dc", "\uc5ec\uc218\uc2dc", "\uc21c\ucc9c\uc2dc", "\ub098\uc8fc\uc2dc", "\uad11\uc591\uc2dc", "\ub2f4\uc591\uad70", "\uace1\uc131\uad70", "\uad6c\ub840\uad70", "\uace0\ud765\uad70", "\ubcf4\uc131\uad70", "\ud654\uc21c\uad70", "\uc7a5\ud765\uad70", "\uac15\uc9c4\uad70", "\ud574\ub0a8\uad70", "\uc601\uc554\uad70", "\ubb34\uc548\uad70", "\ud568\ud3c9\uad70", "\uc601\uad11\uad70", "\uc7a5\uc131\uad70", "\uc644\ub3c4\uad70", "\uc9c4\ub3c4\uad70", "\uc2e0\uc548\uad70"));
        this.cityCountyMap.put("\uacbd\uc0c1\ubd81\ub3c4", Arrays.asList("\ud3ec\ud56d\uc2dc", "\uacbd\uc8fc\uc2dc", "\uae40\ucc9c\uc2dc", "\uc548\ub3d9\uc2dc", "\uad6c\ubbf8\uc2dc", "\uc601\uc8fc\uc2dc", "\uc601\ucc9c\uc2dc", "\uc0c1\uc8fc\uc2dc", "\ubb38\uacbd\uc2dc", "\uacbd\uc0b0\uc2dc", "\uad70\uc704\uad70", "\uc758\uc131\uad70", "\uccad\uc1a1\uad70", "\uc601\uc591\uad70", "\uc601\ub355\uad70", "\uccad\ub3c4\uad70", "\uace0\ub839\uad70", "\uc131\uc8fc\uad70", "\uce60\uace1\uad70", "\uc608\ucc9c\uad70", "\ubd09\ud654\uad70", "\uc6b8\uc9c4\uad70", "\uc6b8\ub989\uad70"));
        this.cityCountyMap.put("\uacbd\uc0c1\ub0a8\ub3c4", Arrays.asList("\ucc3d\uc6d0\uc2dc", "\uc9c4\uc8fc\uc2dc", "\ud1b5\uc601\uc2dc", "\uc0ac\ucc9c\uc2dc", "\uae40\ud574\uc2dc", "\ubc00\uc591\uc2dc", "\uac70\uc81c\uc2dc", "\uc591\uc0b0\uc2dc", "\uc758\ub839\uad70", "\ud568\uc548\uad70", "\ucc3d\ub155\uad70", "\uace0\uc131\uad70", "\ub0a8\ud574\uad70", "\ud558\ub3d9\uad70", "\uc0b0\uccad\uad70", "\ud568\uc591\uad70", "\uac70\ucc3d\uad70", "\ud569\ucc9c\uad70"));
        this.cityCountyMap.put("\uc81c\uc8fc\ud2b9\ubcc4\uc790\uce58\ub3c4", Arrays.asList("\uc81c\uc8fc\uc2dc", "\uc11c\uadc0\ud3ec\uc2dc"));
    }

    private void fetchTotalPages() {
        try {
            String encodedCityCounty = URLEncoder.encode(this.selectedCityCounty, "UTF-8");
            String url = "https://www.safetydata.go.kr/V2/api/DSSP-IF-00247?serviceKey=MT13T4W16LK33RAS&pageNo=1&numOfRows=1&type=json&rgnNm=" + encodedCityCounty;
            Request request = new Request.Builder().url(url).build();
            this.httpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    e.printStackTrace();
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (response.isSuccessful()) {
                        String line;
                        InputStream responseBodyStream = response.body().byteStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(responseBodyStream, StandardCharsets.UTF_8));
                        StringBuilder responseData = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            responseData.append(line);
                        }
                        AlertActivity.this.runOnUiThread(() -> AlertActivity.this.parseTotalPages(responseData.toString()));
                    } else {
                        Log.e((String)"API Error", (String)("Response not successful: " + response.code()));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTotalPages(String responseData) {
        try {
            JSONObject json = new JSONObject(responseData);
            int totalCount = json.optInt("totalCount", 0);
            int totalPages = (int)Math.ceil((double)totalCount / 15.0);
            this.fetchMessages(totalPages);
        }
        catch (JSONException e) {
            Log.e((String)"JSON Parsing Error", (String)e.getMessage());
        }
    }

    private void fetchMessages(int page) {
        this.isLoading = true;
        try {
            String encodedCityCounty = URLEncoder.encode(this.selectedCityCounty, "UTF-8");
            String url = "https://www.safetydata.go.kr/V2/api/DSSP-IF-00247?serviceKey=MT13T4W16LK33RAS&pageNo=" + page + "&numOfRows=15&type=json&rgnNm=" + encodedCityCounty;
            Request request = new Request.Builder().url(url).build();
            this.httpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    AlertActivity.this.isLoading = false;
                    e.printStackTrace();
                }

                public void onResponse(Call call, Response response) throws IOException {
                    AlertActivity.this.isLoading = false;
                    if (response.isSuccessful()) {
                        String line;
                        InputStream responseBodyStream = response.body().byteStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(responseBodyStream, StandardCharsets.UTF_8));
                        StringBuilder responseData = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            responseData.append(line);
                        }
                        AlertActivity.this.runOnUiThread(() -> AlertActivity.this.parseMessages(responseData.toString()));
                    } else {
                        Log.e((String)"API Error", (String)("Response not successful: " + response.code()));
                    }
                }
            });
        }
        catch (Exception e) {
            this.isLoading = false;
            e.printStackTrace();
        }
    }

    private void parseMessages(String responseData) {
        try {
            JSONObject json = new JSONObject(responseData);
            JSONArray body = json.optJSONArray("body");
            if (body != null) {
                this.messages.clear();
                for (int i = 0; i < body.length(); ++i) {
                    JSONObject item = body.getJSONObject(i);
                    String content = item.getString("MSG_CN");
                    String date = item.getString("REG_YMD");
                    if (date.contains(".")) {
                        date = date.substring(0, date.indexOf("."));
                    }
                    this.messages.add(new DisasterMessage(content, date));
                }
                this.messages.sort((msg1, msg2) -> msg2.getDate().compareTo(msg1.getDate()));
                this.updateMessageList(this.messages);
            }
        }
        catch (JSONException e) {
            Log.e((String)"JSON Error", (String)e.getMessage());
        }
    }

    private void updateMessageList(List<DisasterMessage> messages) {
        this.messageList.removeAllViews();
        for (DisasterMessage msg : messages) {
            LinearLayout msgBox = new LinearLayout((Context)this);
            msgBox.setOrientation(1);
            msgBox.setPadding(16, 16, 16, 16);
            msgBox.setBackgroundResource(17301683);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            params.setMargins(0, 0, 0, 16);
            msgBox.setLayoutParams((ViewGroup.LayoutParams)params);
            TextView msgView = new TextView((Context)this);
            msgView.setText((CharSequence)(msg.getContent() + "\n" + msg.getDate()));
            msgView.setTextSize(16.0f);
            msgView.setTextColor(this.getResources().getColor(17170444));
            msgBox.addView((View)msgView);
            msgBox.setOnClickListener(v -> this.showDialog(msg.getContent(), msg.getDate()));
            this.messageList.addView((View)msgBox);
        }
    }

    private void showDialog(String title, String content) {
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View dialogView = inflater.inflate(R.layout.dialog_alertplus, null);
        TextView titleView = (TextView)dialogView.findViewById(R.id.dialogTitle);
        TextView contentView = (TextView)dialogView.findViewById(R.id.dialogContent);
        Button closeBtn = (Button)dialogView.findViewById(R.id.closeButton);
        titleView.setText((CharSequence)title);
        contentView.setText((CharSequence)content);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setView(dialogView);
        AlertDialog dialog = builder.create();
        closeBtn.setOnClickListener(v -> dialog.dismiss());
        dialog.show();
    }

    private List<DisasterMessage> filterMessages(String query) {
        ArrayList<DisasterMessage> filtered = new ArrayList<DisasterMessage>();
        for (DisasterMessage msg : this.messages) {
            if (!msg.getContent().contains(query)) continue;
            filtered.add(msg);
        }
        return filtered;
    }

    private class DisasterMessage {
        private String content;
        private String date;

        public DisasterMessage(String content, String date) {
            this.content = content;
            this.date = date;
        }

        public String getContent() {
            return this.content;
        }

        public String getDate() {
            return this.date;
        }
    }
}

