package com.howon.lifepass;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

public class DisasterActivity extends AppCompatActivity {

    private LinearLayout naturalGroup, socialGroup;
    private Button naturalButton, socialButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_disaster);
        // 하단바 버튼 초기화
        ImageButton bottomButton1 = findViewById(R.id.bottomButton1);
        ImageButton bottomButton2 = findViewById(R.id.bottomButton2);
        ImageButton bottomButton3 = findViewById(R.id.bottomButton3);
        ImageButton bottomButton4 = findViewById(R.id.bottomButton4);
        // 버튼 클릭 이벤트 설정
        View.OnClickListener bottomButtonListener = v -> {
            int id = v.getId();
            if (id == R.id.bottomButton4) {
                Toast.makeText(DisasterActivity.this, "현재 페이지입니다.", Toast.LENGTH_SHORT).show();
            } else if (id == R.id.bottomButton2) {
                startActivity(new Intent(DisasterActivity.this, AlertActivity.class));
            } else if (id == R.id.bottomButton3) {
                startActivity(new Intent(DisasterActivity.this, NotificationActivity.class));
            } else if (id == R.id.bottomButton1) {
                startActivity(new Intent(DisasterActivity.this, WeatherActivity.class));
            }
        };
        bottomButton1.setOnClickListener(bottomButtonListener);
        bottomButton2.setOnClickListener(bottomButtonListener);
        bottomButton3.setOnClickListener(bottomButtonListener);
        bottomButton4.setOnClickListener(bottomButtonListener);

        // UI 요소 초기화
        naturalButton = findViewById(R.id.naturalButton);
        socialButton = findViewById(R.id.socialButton);
        naturalGroup = findViewById(R.id.naturalGroup);
        socialGroup = findViewById(R.id.socialGroup);

        // 기본적으로 자연재난 그룹 표시
        naturalGroup.setVisibility(View.VISIBLE);
        socialGroup.setVisibility(View.GONE);

        // 자연재난 버튼 클릭
        naturalButton.setOnClickListener(view -> {
            naturalGroup.setVisibility(View.VISIBLE);
            socialGroup.setVisibility(View.GONE);
        });

        // 사회재난 버튼 클릭
        socialButton.setOnClickListener(view -> {
            naturalGroup.setVisibility(View.GONE);
            socialGroup.setVisibility(View.VISIBLE);
        });

        // 재난 버튼 클릭 이벤트 처리
        findViewById(R.id.heatWaveButton).setOnClickListener(view -> {
            startActivity(new Intent(this, HeatWaveActivity.class));
        });

        findViewById(R.id.typhoonButton).setOnClickListener(view -> {
            startActivity(new Intent(this, TyphoonActivity.class));
        });

        findViewById(R.id.heavyRainButton).setOnClickListener(view -> {
            startActivity(new Intent(this, HeavyRainActivity.class));
        });

        findViewById(R.id.yellowDustButton).setOnClickListener(view -> {
            startActivity(new Intent(this, YellowDustActivity.class));
        });
    }
}
