package com.howon.lifepass;

import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.google.firebase.firestore.FirebaseFirestore;

public class EditNoticeActivity extends AppCompatActivity {

    private FirebaseFirestore db;
    private String documentId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit_notice);

        db = FirebaseFirestore.getInstance();

        // EditText와 버튼 참조
        EditText editTitle = findViewById(R.id.edit_text_title);
        EditText editContent = findViewById(R.id.edit_text_content);
        Button saveButton = findViewById(R.id.btn_save);

        // Intent로 전달된 데이터 가져오기
        documentId = getIntent().getStringExtra("documentId");
        String title = getIntent().getStringExtra("title");
        String content = getIntent().getStringExtra("content");

        // 기존 데이터 설정
        editTitle.setText(title);
        editContent.setText(content);

        // 저장 버튼 클릭 이벤트
        saveButton.setOnClickListener(v -> {
            String updatedTitle = editTitle.getText().toString().trim();
            String updatedContent = editContent.getText().toString().trim();

            if (updatedTitle.isEmpty() || updatedContent.isEmpty()) {
                Toast.makeText(this, "제목과 내용을 입력해주세요.", Toast.LENGTH_SHORT).show();
                return;
            }

            // Firestore에 데이터 업데이트
            db.collection("notices").document(documentId)
                    .update("title", updatedTitle, "content", updatedContent)
                    .addOnSuccessListener(aVoid -> {
                        Toast.makeText(this, "공지사항이 수정되었습니다.", Toast.LENGTH_SHORT).show();
                        finish(); // 수정 완료 후 이전 화면으로 이동
                    })
                    .addOnFailureListener(e -> {
                        Toast.makeText(this, "수정 실패: " + e.getMessage(), Toast.LENGTH_SHORT).show();
                    });
        });
    }
}
