package com.howon.lifepass;

import android.os.Bundle;
import android.view.View;
import android.widget.ImageButton;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

public class FireActivity extends AppCompatActivity {

    private ImageButton button1, button2, button3, disasterButton; // ImageButton들

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_fire); // 화재 관련 레이아웃

        // 하단 네비게이션 버튼 연결
        button1 = findViewById(R.id.bottomButton1); // Weather 버튼
        button2 = findViewById(R.id.bottomButton2); // Alert 버튼
        button3 = findViewById(R.id.bottomButton3); // Notification 버튼
        disasterButton = findViewById(R.id.bottomButton4); // Disaster 버튼

        // 카드 1 클릭 이벤트 (화재대비 행동요령)
        findViewById(R.id.card1).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setContentView(R.layout.activity_fire1);
            }
        });

        // 카드 2 클릭 이벤트 (화재대처 행동요령)
        findViewById(R.id.card2).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setContentView(R.layout.activity_fire2);
            }
        });

        // 카드 3 클릭 이벤트 (화재진압 행동요령)
        findViewById(R.id.card3).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setContentView(R.layout.activity_fire3);
            }
        });

        // 카드 4 클릭 이벤트 (소방관이 전하는 안전상식)
        findViewById(R.id.card4).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setContentView(R.layout.activity_fire4);
            }
        });

        // 카드 5 클릭 이벤트 (소화기 사용법)
        findViewById(R.id.card5).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setContentView(R.layout.activity_fire5);
            }
        });

        // 하단 네비게이션 버튼 1 클릭 이벤트
        button1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(FireActivity.this, "WeatherActivity 연결", Toast.LENGTH_SHORT).show();
            }
        });

        // 하단 네비게이션 버튼 2 클릭 이벤트
        button2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(FireActivity.this, "AlertActivity 연결", Toast.LENGTH_SHORT).show();
            }
        });

        // 하단 네비게이션 버튼 3 클릭 이벤트
        button3.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(FireActivity.this, "NotificationActivity 연결", Toast.LENGTH_SHORT).show();
            }
        });

        // 하단 네비게이션 버튼 4 클릭 이벤트
        disasterButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Toast.makeText(FireActivity.this, "DisasterActivity 연결", Toast.LENGTH_SHORT).show();
            }
        });
    }
}
