package com.howon.lifepass;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    private ImageButton button1, button2, button3, disasterButton; // ImageButton들
    private TextView recentAlertText; // 최근 재난문자 텍스트 뷰 (사용할 경우 추가)

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);  // XML 레이아웃 연결

        // 버튼과 텍스트 뷰를 XML에서 찾아서 자바 코드와 연결
        button1 = findViewById(R.id.weatherButton);
        button2 = findViewById(R.id.alertButton);
        button3 = findViewById(R.id.notificationButton);
        disasterButton = findViewById(R.id.disasterButton); // 재난 버튼 추가

        // 버튼 1 클릭 이벤트 (날씨)
        button1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MainActivity.this, WeatherActivity.class);
                startActivity(intent);
            }
        });

        // 버튼 2 클릭 이벤트 (재난문자)
        button2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MainActivity.this, AlertActivity.class);
                startActivity(intent);
            }
        });

        // 버튼 3 클릭 이벤트 (학과 알림)
        button3.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MainActivity.this, NotificationActivity.class);
                startActivity(intent);
            }
        });

        // 재난 버튼 클릭 이벤트 (재난 액티비티로 이동)
        disasterButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent(MainActivity.this, DisasterActivity.class);
                startActivity(intent);
            }
        });

        // (선택 사항) 예제 Toast 메시지 추가 가능
        // Toast.makeText(this, "앱 실행됨", Toast.LENGTH_SHORT).show();
    }
}
