package com.howon.lifepass;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.google.firebase.firestore.FirebaseFirestore;

public class NoticeDetailActivity extends AppCompatActivity {

    private FirebaseFirestore db; // Firestore 인스턴스
    private String documentId;    // Firestore 문서 ID

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_notice_detail);

        // Firestore 초기화
        db = FirebaseFirestore.getInstance();

        // TextView 참조
        TextView titleTextView = findViewById(R.id.text_view_title);
        TextView authorTextView = findViewById(R.id.text_view_author);
        TextView dateTextView = findViewById(R.id.text_view_date);
        TextView contentTextView = findViewById(R.id.text_view_content);

        // Intent로 전달된 데이터 가져오기
        String title = getIntent().getStringExtra("title");
        String author = getIntent().getStringExtra("author");
        String content = getIntent().getStringExtra("content");
        documentId = getIntent().getStringExtra("documentId"); // 클래스 변수에 저장

        long createdAtMillis = getIntent().getLongExtra("createdAt", -1);
        String formattedDate = createdAtMillis != -1
                ? new java.text.SimpleDateFormat("yyyy년 MM월 dd일 HH:mm:ss", java.util.Locale.getDefault())
                .format(new java.util.Date(createdAtMillis))
                : "작성 시간 없음";

        // TextView에 데이터 설정
        titleTextView.setText(title != null ? title : "제목 없음");
        authorTextView.setText(author != null ? author : "작성자 없음");
        dateTextView.setText(formattedDate);
        contentTextView.setText(content != null ? content : "내용이 없습니다.");

        // 수정 버튼 클릭 이벤트
        Button editButton = findViewById(R.id.btn_edit);
        editButton.setOnClickListener(v -> {
            Intent intent = new Intent(NoticeDetailActivity.this, EditNoticeActivity.class);
            intent.putExtra("documentId", documentId); // 문서 ID 전달
            intent.putExtra("title", titleTextView.getText().toString()); // 제목 전달
            intent.putExtra("content", contentTextView.getText().toString()); // 내용 전달
            startActivity(intent);
        });

        // 삭제 버튼 클릭 이벤트
        Button deleteButton = findViewById(R.id.btn_delete);
        deleteButton.setOnClickListener(v -> {
            if (documentId != null) {
                db.collection("notices").document(documentId)
                        .delete()
                        .addOnSuccessListener(aVoid -> {
                            Toast.makeText(this, "공지사항이 삭제되었습니다.", Toast.LENGTH_SHORT).show();
                            finish();
                        })
                        .addOnFailureListener(e -> Toast.makeText(this, "삭제 실패: " + e.getMessage(), Toast.LENGTH_SHORT).show());
            } else {
                Toast.makeText(this, "문서 ID가 없습니다.", Toast.LENGTH_SHORT).show();
            }
        });
    }
}
